// /////////////////////////////////////////////////////////////////////////////
// DR DOBB'S CHALLENGES
//
// Filename       : EntityPlatform.cpp
// Date           : February 2008
//
// Description    : Refer to description in corresponding header.
//
// ///////////////////////////////////////////////////////////////////////////


#include "EntityPlatform.h"
#include "Level.h"




EntityPlatform::EntityPlatform() 
{

  m_MoveCarriedObjectFlags = Dobbs::DIR_PLATFORM_MOVE;

  m_Active    = false;
  m_CanSleep  = false;

  m_Floating = true;
  SetFrame( Dobbs::ANIM_PLATFORM );
  SetRect( &m_CollisionRect, 0, 0, 127, 31 );

}



EntityPlatform::~EntityPlatform() 
{
}



void EntityPlatform::OnEvent( const EntityEvent Event, int Param1, int Param2, const std::string& TextParam, Entity* pEntity )
{

  switch ( Event )
  {
    case EE_INIT:
      SetDirection( (Dobbs::DirFlags)m_ExtraData );
      break;
    case EE_BLOCKED_LEFT:
      SetDirection( Dobbs::DIR_RIGHT );
      break;
    case EE_BLOCKED_RIGHT:
      SetDirection( Dobbs::DIR_LEFT );
      break;
    case EE_BLOCKED_TOP:
      SetDirection( Dobbs::DIR_DOWN );
      break;
    case EE_BLOCKED_BOTTOM:
      SetDirection( Dobbs::DIR_UP);
      break;
    case EE_CARRY:
      m_Active = true;
      //m_Direction = pEntity->Direction();
      break;
    case EE_DROP:
      break;
  }
  Entity::OnEvent( Event, Param1, Param2, TextParam, pEntity );

}



void EntityPlatform::UpdateTimed( Level& aLevel, float ElapsedTime )
{

  Entity::UpdateTimed( aLevel, ElapsedTime );
  if ( m_Active )
  {
    if ( m_Direction == Dobbs::DIR_RIGHT )
    {
      Move( aLevel, 120.0f * ElapsedTime, 0.0f, Dobbs::DIR_RIGHT );
    }
    else if ( m_Direction == Dobbs::DIR_LEFT )
    {
      Move( aLevel, -120.0f * ElapsedTime, 0.0f, Dobbs::DIR_LEFT );
    }
    else if ( m_Direction == Dobbs::DIR_UP )
    {
      Move( aLevel, 0.0f, -120.0f * ElapsedTime, Dobbs::DIR_UP );
    }
    else if ( m_Direction == Dobbs::DIR_DOWN )
    {
      Move( aLevel, 0.0f, 120.0f * ElapsedTime, Dobbs::DIR_DOWN );
    }
  }

}